using Microsoft.EntityFrameworkCore;
using ProductMicroservice.Models;

namespace ProductMicroservice.Data
{
	public class AppDbContext : DbContext
	{
		public AppDbContext(DbContextOptions<AppDbContext> options) : base(options)
		{
		}

		public DbSet<Customer> Customers => Set<Customer>();

		protected override void OnModelCreating(ModelBuilder modelBuilder)
		{
			base.OnModelCreating(modelBuilder);
			modelBuilder.Entity<Customer>().ToTable("customer", "public");
			modelBuilder.Entity<Customer>()
				.Property(c => c.CreateDate)
				.HasConversion(
					v => v.ToDateTime(TimeOnly.MinValue),
					v => DateOnly.FromDateTime(v)
				)
				.HasColumnType("date");
		}
	}
} 