using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace ProductMicroservice.Models
{
	[Table("customer", Schema = "public")]
	public class Customer
	{
		[Key]
		[Column("customer_id")]
		public int CustomerId { get; set; }

		[Column("store_id")]
		public short StoreId { get; set; }

		[Required]
		[MaxLength(45)]
		[Column("first_name")]
		public string FirstName { get; set; } = string.Empty;

		[Required]
		[MaxLength(45)]
		[Column("last_name")]
		public string LastName { get; set; } = string.Empty;

		[MaxLength(50)]
		[Column("email")]
		public string? Email { get; set; }

		[Column("address_id")]
		public int AddressId { get; set; }

		[Column("activebool")]
		public bool ActiveBool { get; set; }

		[Column("create_date")]
		public DateOnly CreateDate { get; set; }

		[Column("last_update")]
		public DateTime? LastUpdate { get; set; }
	}
} 