using ProductMicroservice.Models;

namespace ProductMicroservice.Services
{
	public interface ICustomerService
	{
		Task<List<Customer>> GetAllAsync(CancellationToken cancellationToken = default);
		Task<Customer?> GetByIdAsync(int id, CancellationToken cancellationToken = default);
		Task<Customer> CreateAsync(Customer customer, CancellationToken cancellationToken = default);
		Task<bool> UpdateAsync(int id, Customer customer, CancellationToken cancellationToken = default);
		Task<bool> DeleteAsync(int id, CancellationToken cancellationToken = default);
	}
} 